/*********************************************************************/
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2005, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/*********************************************************************/

//-------------------------------------------------------------
// global vars used to control dynamic toc behaviour

// Class names indicate whether ajax request is necessary
var TWISTY_CLASS			= "h-img-twisty"
var TWISTY_CLASS_AJAX	= "h-img-ajaxTwisty"
						 
// twist and folder states
var COLLAPSED 				=  0;
var EXPANDED  				=  1;
var NONE      				=  2;
var LOADING      			=  3;
var SELECTED      		=  4;
var RESTRICTED      		=  5;

// standard width of the icons
var ICON_WIDTH 				= 14;


//TODO - START - probably need a mechanism to translate these strings???
var twistImgAlt = new Array();
twistImgAlt[COLLAPSED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.EXPAND");
twistImgAlt[EXPANDED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.COLLAPSE");
twistImgAlt[NONE] 			= "";

var folderImgAlt = new Array();
folderImgAlt[COLLAPSED] 	= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER");
folderImgAlt[EXPANDED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER");
folderImgAlt[NONE] 			= "";
folderImgAlt[SELECTED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER_SELECTED");
folderImgAlt[RESTRICTED] 	= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER_RESTRICTED");
//TODO - END


//images to be used for the expand/collapse twisties in the TOC
var twistImg = new Array();
twistImg[COLLAPSED]  		= "/qphtml/html/common/folder_twist_open.gif";
twistImg[EXPANDED] 			= "/qphtml/html/common/folder_twist_close.gif";
twistImg[NONE] 				= "/qphtml/html/common/transparent.gif";
twistImg[LOADING] 			= "/qphtml/html/common/ajax_loader.gif";
								  
var twistImgTag = new Array();
twistImgTag[COLLAPSED] 		= "<img style='padding-left:%PLpx;' class='" + TWISTY_CLASS_AJAX + "' src='" + twistImg[COLLAPSED] + "' width='" + ICON_WIDTH + "' border='0' align='middle' title='" + twistImgAlt[COLLAPSED] + "' alt='" + twistImgAlt[COLLAPSED] + "' onclick='javascript:twist(this,%d);'/>";
twistImgTag[EXPANDED] 		= "<img style='padding-left:%PLpx;' class='" + TWISTY_CLASS + "' src='" + twistImg[EXPANDED] + "' width='" + ICON_WIDTH + "' border='0' align='middle' title='" + twistImgAlt[EXPANDED] + "' alt='" + twistImgAlt[EXPANDED] + "' onclick='javascript:twist(this,%d);'/>";
twistImgTag[NONE] 			= "<img style='padding-left:%PLpx;' src='" + twistImg[NONE] + "' width='" + ICON_WIDTH + "' border='0' height='1' align='middle' title='" + twistImgAlt[NONE] + "' alt='" + twistImgAlt[NONE] + "' />";



//images to be used for the open/close Folders in the TOC
var folderImg = new Array();
folderImg[COLLAPSED] 	= "/qphtml/html/common/folder_close.gif";
folderImg[EXPANDED] 		= "/qphtml/html/common/folder_open.gif";
folderImg[NONE] 			= "/qphtml/html/common/transparent.gif";
folderImg[SELECTED] 		= "/qphtml/html/common/folder_selected.gif";
folderImg[RESTRICTED] 	= "/qphtml/html/common/folder_closed_grayed.gif";
		
var folderImgTag = new Array();
folderImgTag[COLLAPSED] 	= "<img src='" + folderImg[COLLAPSED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[COLLAPSED] + "' alt='" + folderImgAlt[COLLAPSED] + "' />";
folderImgTag[EXPANDED] 		= "<img src='" + folderImg[EXPANDED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[EXPANDED] + "' alt='" + folderImgAlt[EXPANDED] + "' />";
folderImgTag[NONE] 			= "<img src='" + folderImg[NONE] + "' border='0' align='middle' width='" + ICON_WIDTH + "' height='1' title='" + folderImgAlt[NONE] + "' alt='" + folderImgAlt[NONE] + "' />";
folderImgTag[SELECTED] 	= "<img src='" + folderImg[SELECTED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[SELECTED] + "' alt='" + folderImgAlt[SELECTED] + "' />";
folderImgTag[RESTRICTED] 	= "<img src='" + folderImg[RESTRICTED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[RESTRICTED] + "' alt='" + folderImgAlt[RESTRICTED] + "' />";

var goUpIconTag = '<img src="/qphtml/html/common/goup.gif" align="absbottom" width=12 height=16 alt="" border="0" />';

// Image for (sub)folder
var imgFolder = "";
dojo.addOnLoad(function(){
	window.imgFolder = encodeURIComponent(GetDocTypeIconImgTag(D_QPTypeFolder));
});

var g_parentUnid=null;
var g_parentTwisty=null;
var g_parentDiv=null;
var g_parentLevel=0;

// Twisty folder expansion functions
var twistExpFunc = new Array();
twistExpFunc[0] = addFoldersToToc;
twistExpFunc[1] = addFoldersToSelector;

//-------------------------------------------------------------------
// addTocItemObj( ):
//    called from the toc component, this is the main entry point to
//    the dynamic table of contents infrastructure.
//    Appends a TOC node to the TOC div in the DOM.
//
// Arguments:
//		name   : the plain text name of the toc item
//		url    : the url the pointed to by the toc item
//		icon   : the reprensenting icon img tag of the toc item
//    level  : the hierarchy level of the toc item
//    state  : the current twist (collapsed/expanded) state of the toc item
//		type   : the type of toc item, as follows:
//						D_QPTypePage					"0"
//						D_QPTypeFolder					"1"
//						D_QPTypeRoomSettings				"2"
//						D_QPTypeRoom					"3"
//						D_QPTypeError					"4"
//						D_QPTypeAreaType				"5"
//		selected: true|false whether the toc item is selected or not.
//
function addTocItemObj(name, unid, url, icon, level, state, type, selected, sysName, bCanPublish, bNewWindow)
{
	var toc=document.getElementById("toc");
	var item=getTocItemNode(name, unid, url, icon, level, state, type, selected, sysName, bCanPublish, bNewWindow);
	if (toc && item)
	{
		toc.appendChild(item);
	}
}

// Generates DOM element for a TOC item
function getTocItemNode(name, unid, url, icon, level, state, type, selected, sysName, bCanPublish, bNewWindow)
{
	var iEF = 0;
	var bIsSelected = selected || false;
	var bCanDragTo = (typeof bCanPublish == 'undefined' ? false : bCanPublish);
	icon = decodeURIComponent(icon);
	try {
		name = decodeURIComponent(name);
	} catch (e) {}
	if (name == QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.GO_UP")) {
		icon = goUpIconTag;
	}

	// default twisty and icon images
	var twisty = twistImgTag[NONE];

	// set twisty anchor and image to  + or - for toc items with state of collapse or expand
	if ( state == EXPANDED || state == COLLAPSED )
	{
		twisty = twistImgTag[state].replace(/%d/g, iEF.toString());
		icon = folderImgTag[state];
	}

	// Determine whether this TOC item represents a folder
	var bIsFolder = (type == "1" && icon.indexOf("folder_") > -1);

	// Get appropriate icon if folder
	if (bIsFolder) {
		if (!bCanDragTo && currentUserAccess > 2) {
			// User access above Reader, but can't drag to THIS folder
			icon = folderImgTag[RESTRICTED];
		}
		else if (bIsSelected) {
			// Show folder "open"
			icon = folderImgTag[EXPANDED];
		}
	}

	// indentation for expandable items
	var indentPx = level * 10;
	twisty = twisty.replace(/%PL/, indentPx);

	// link elements for anchor
	var itemHref  = ' href="' + url + '" ' 
	var itemClass = bIsSelected ? '" class="tocSelected-text" ' : '';

	// Create anchor for TOC item
	var anchor = '<a' + itemHref + itemClass + (bNewWindow ? ' TARGET="_blank" ' : '')+ '>' + icon + QuickrGeneralUtil.encodeEntities(name)	+ '</a>'; // BBXSS Change
	
	var tocClass = (bIsSelected ? 'tocSelected-bg' : 'toc-bg') + (bIsFolder ? ' dropTarget' : '');
	var tocTitle = (bIsFolder ? QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER") : '');

	// Now create the DOM element itself:
	var tocItem = document.createElement("div");
	tocItem.id = (bIsFolder ? sysName : '');
 	tocItem.className = tocClass;
 	tocItem.style.display = "block";
	tocItem.title = tocTitle;
	tocItem.setAttribute("unid", unid);
	tocItem.setAttribute("level", level);
	tocItem.innerHTML = twisty + anchor;

	if (bIsFolder && bCanDragTo && currentUserAccess > 2) {
		// Make this folder a drop target
		QP_DragAndDrop_initDropTarget(tocItem);
	}

	return tocItem;
}


//-------------------------------------------------------------------
//
var G_greenFolder = null;

function addFolderSelectorObj(name, sysName, unid, url, level, state, bCanPublish)
{
	var toc=document.getElementById("folderSelector");
	var item=getFolderSelectorNode(name, sysName, unid, url, level, state, bCanPublish);
	if (toc && item)
	{
		toc.appendChild(item);
	}
}

// Generates DOM element for a Folder selector
function getFolderSelectorNode(name, sysName, unid, url, level, state, bCanPublish)
{
	// default twisty and icon images
	var twisty = twistImgTag[NONE];
	var icon = decodeURIComponent(imgFolder);

	// set twisty anchor and image to  + or - for toc items with state of collapse or expand
	if ( state == EXPANDED || state == COLLAPSED )
	{
		twisty = twistImgTag[state].replace(/%d/g, "1");
		icon = folderImgTag[state];
	}

	// indentation for expandable items
	var indentPx = level * 10;
	twisty = twisty.replace(/%PL/, indentPx);
	

	
	// Create anchor for folder selector
	if (bCanPublish) {
		var anchor = '<a onclick="' + url + 'makeMeGreen(this);" href="javascript:void(0)">' + icon + name + '</a>';
	}
	else {
		// Publishing not allowed: change icon & disable click action
		icon = folderImgTag[RESTRICTED];
		anchor = '<a onclick="' + G_FolderSectionAction_CantPublish + '" href="javascript:void(0)">' + icon + name + '</a>';
	}
	
	// Now create the DOM element itself:
	var tocItem = document.createElement("div");
	tocItem.id = sysName;
 	tocItem.className = "toc-bg";
 	tocItem.style.display = "block";
	tocItem.title = name;
	tocItem.setAttribute("unid", unid);
	tocItem.setAttribute("level", level);
	tocItem.innerHTML = twisty + anchor;

	return tocItem;
}

// NOTE: This function must exist in order for the default folder to be highlighted!
function hiliteFolderSelectorByUnid(unid)
{
	var fsel=document.getElementById("folderSelector");
	if (fsel) {
		var divs=fsel.getElementsByTagName("div");
		for (var i=0; i<divs.length; i++) {
			if (divs[i].getAttribute("unid") == unid) {
				var a = divs[i].getElementsByTagName("a");
				if (a[0]) {
					makeMeGreen(a[0]);
				}
			}
		}
	}
}

function makeMeGreen(me)
{
	var imgs = me.getElementsByTagName("img");
	if (imgs[0]) {
		if (G_greenFolder != null)
			G_greenFolder.src = folderImg[COLLAPSED];
		imgs[0].src = folderImg[SELECTED];
		G_greenFolder = imgs[0];
	}
}

// Called when a folder twisty is clicked
function twist(obj, i)
{
	if (obj.alt==twistImgAlt[EXPANDED])
		showHideAllSubF(obj, false);
	else
		expSubF(obj, i);
}

// Expand subfolder(s), requesting data from server if necessary
function expSubF(twisty, iExpFunc)
{
	if (twisty.className == TWISTY_CLASS_AJAX) {
		// Need to request subfolder data from server: get parent UNID
		var unid=twisty.parentNode.getAttribute("unid");
		if (unid) {
			// Set parent folder data for use by callback function
			g_parentTwisty=twisty;
			g_parentDiv=twisty.parentNode;
			g_parentLevel=parseInt(g_parentDiv.getAttribute("level"));
			g_parentUnid=g_parentDiv.getAttribute("unid");
			  
			// Request next-level subfolder data asynchronously
			ajax = new QPAjax();
			
			// Fix the problem JROE8889NW and KSAA7WTDFX
			var tmpURL = location.href.replace("?EditDocument&", "../../cf07bfcad7af887a0525670800167221/ce6a3d6b1f546c9405256708001671ff/?OpenDocument&");
			// SPR#JROE8889NW: backed out "fix" for KSAA7WTDFX below because this generated a malformed URL - 8/12/10 Bill R
			ajax.RequestJS((tmpURL + "&Form=h_FolderJSON&charset=utf-8&nowebcaching&PreSetFields=h_ParentUnid;"+unid),
			// SPR#KSAA7WTDFX
			//ajax.RequestJS((location.hostname + location.pathname + "?OpenDocument" + "&Form=h_FolderJSON&charset=utf-8&nowebcaching&PreSetFields=h_ParentUnid;"+unid),
								twistExpFunc[iExpFunc],
								"get",
								expSubFError);
			  
			// Change twisty icon to show data is loading
			twisty.src=twistImg[LOADING];
		}
	}
	else {
		// Subfolders already there - simply show
		showHideAllSubF(twisty, true);
	}
}

// Handle no data returned from server
function expSubFError(error)
{
	setTwistyObj(g_parentTwisty, COLLAPSED);
}

function sortbyitemstitle(x, y)
{
  	if(x.item.title > y.item.title)   return   -1;  
  	else   if(x.item.title < y.item.title)   return   1;  
  	else   return   0;   
}

// Callback: Create TOC item for each JSON data element in the response
function addFoldersToToc(data)
{
	g_parentTwisty.className = TWISTY_CLASS;	// so won't request data next time

	var items = data.items;
	items.sort(sortbyitemstitle);
	for (var i=0; i < items.length; i++) 
	{
		var item=items[i].item;
		
		if (typeof (item.unid) == "undefined" && typeof (item.ancestry) != "undefined") {
			var tmp = item.ancestry.split("~");
			item.unid = tmp[tmp.length-1];
		}		

		var tocItem=getTocItemNode(
			 item.title,
			 item.unid,
			 "../../h_Toc/" + item.unid + "/?OpenDocument",
			 imgFolder,
			 g_parentLevel+1,
			 (item.hasSubfolder=="1" ? COLLAPSED : NONE),
			 item.type,
			 false,
			 item.SystemName,
			 (item.canAddDocs=="1" || currentUserAccess >= 6));

		var tocDiv=document.getElementById("toc");

		if (tocItem && tocDiv && g_parentDiv) {
			if (div=getNextSiblingByTag(g_parentDiv, "div")) {
				// Insert item before next item
				tocDiv.insertBefore(tocItem, div);
			}
			else {
				// ...or at end, if there is no next item
				tocDiv.appendChild(tocItem);
			}

			// Change parent's twisty
			setTwistyObj(g_parentTwisty, EXPANDED);
		}
	}
}

// Callback: Create folder selector for each JSON data element in the response
function addFoldersToSelector(data)
{
	g_parentTwisty.className = TWISTY_CLASS;	// so won't request data next time

	var numAdded = 0;

	var items = data.items;
	for (var i=0; i < items.length; i++) 
	{
		var item=items[i].item;

		if (item.subStyle == "h_List" || item.subStyle == "h_ForumBoard") {
			// Don't show lists or fourms
			continue;
		}

		var proxyUnid = ((h_PublishedVersionUNID == "") ? h_PageUnid : h_PublishedVersionUNID);
		
		//SPR:#JSHN7QETQE 
		var tmpTitle = item.title;
		tmpTitle = replaceStr(tmpTitle, "&#39;", "&#92;&#39;"); //&#92;&#39; are escape characters of \'
		tmpTitle = replaceStr(tmpTitle, '&quot;', '&#92;&#34;'); //&#92;&#34; are escape characters of \"
		// ADD hierarchy of this parent folder
		var url = "javascript:setFolderName(" + "'" + item.SystemName + "'," +
			 "'" + item.unid			+ "'," +
			 "'" + tmpTitle			+ "'," +
			 "'" + item.style			+ "'," +
			 "'" + item.sortOrder	+ "'," +
			 "'" + item.sortColumn	+ "'," +
			 "'" + item.ancestry + "~" + proxyUnid + "'," +
			 "'" + g_parentUnid  + "'," +
			 true + "," +
			 false +
			 ");";

		var tocItem=getFolderSelectorNode(
			 item.title,
			 item.SystemName,
			 item.unid,
			 url,
			 g_parentLevel+1,
			 (item.hasSubfolder=="1" ? COLLAPSED : NONE),
			 (item.canAddDocs=="1" || currentUserAccess >= 6));

		var tocDiv=document.getElementById("folderSelector");

		if (tocItem && tocDiv && g_parentDiv) {
			if (div=getNextSiblingByTag(g_parentDiv, "div")) {
				// Insert item before next item
				tocDiv.insertBefore(tocItem, div);
			}
			else {
				// ...or at end, if there is no next item
				tocDiv.appendChild(tocItem);
			}
			numAdded++;
		}
	}

	// Change parent's twisty
	setTwistyObj(g_parentTwisty, (numAdded > 0 ? EXPANDED : NONE));
}

// Show or hide all subfolders under parent folder
function showHideAllSubF(twisty, bShow)
{
	g_parentDiv=twisty.parentNode;
	g_parentLevel=parseInt(g_parentDiv.getAttribute("level"));

	// TOC item to start at
	var div=getNextSiblingByTag(twisty.parentNode, "div");
	 
	while (div != null
			 && (lev=div.getAttribute("level")) != null
			 && parseInt(lev) > g_parentLevel)
	{
		if (bShow) {
			if ((ch0=div.childNodes[0]) && ch0.tagName=="IMG" && ch0.className==TWISTY_CLASS)
 				setTwistyObj(ch0,EXPANDED);
			div.style.display="block";
		}
		else {
			div.style.display="none";
		}
		div=getNextSiblingByTag(div, "div");
	}

	setTwistyObj(twisty,(bShow ? EXPANDED : COLLAPSED));
}

// Set twisty element to reflect state
function setTwistyObj(obj, state)
{
	obj.src = twistImg[state];
	obj.alt = twistImgAlt[state];
	obj.title = obj.alt;
}

// Get next sibling with specified tag.
function getNextSiblingByTag(obj, tag)
{
	var szTag=tag.toUpperCase();
	for (sib=obj.nextSibling; sib != null; sib=sib.nextSibling) {
		if (sib.nodeName.toUpperCase()==szTag)
			return sib;
	}
	return null;
}
